# 비트마스크(Bitmask)

> 컴퓨터 과학에서 **마스크(mask)** 또는 **비트마스크(bitmask)** 는 특히 비트 필드에서 비트 연산에 사용되는 데이터이다. 마스크를 사용하면 바이트, 니블, 워드 등의 다중 비트들을 싱글 비트 연산 작업에서 켜고 끄거나 상호 반전시킬 수 있다. [_wiki_](<https://ko.wikipedia.org/wiki/마스크_(컴퓨팅)>)

<br/>

- 일반적으로 `마스킹(Masking)`은 정보의 부분들을 유지하고, 바꾸고, 제거하는 것이다.
- 프로그래밍에서 `마스킹(Masking)`은 비트연산을 통해서 값에 마스크를 적용하는 것이다.
- 프로그래밍에서 `마스크(Mask)`는 바이너리 숫자에서 어떤 비트를 유지하고 어떤 비트를 지울지 결정한다.

`비트마스킹`은 알고리즘보다는 값을 자료구조처럼 사용하는 하나의 **기법** 에 가깝다.  
`마스크`는 하나의 값으로 다른 정보들을 나타내는데 사용할 수 있으며, 대표적으로 비트마스킹을 사용하여 **집합의 부분집합** 을 나타낼 수 있다.  
_이는 DP(Dynamic Programming)에서 유용하게 쓰인다._

<br/>

## 비트마스킹 집합 표현

마스크로 다음과 같이 부분집합을 표현할 수 있다.

N = 3, Set S = { item1, item2, item3 }

| Mask | Subsets                 |
| :--: | :---------------------- |
| 000  | { }                     |
| 001  | { item3 }               |
| 101  | { item1, item3 }        |
| 111  | { item1, item2, item3 } |

<br/>

## 비트 연산

<!-- prettier-ignore -->
| Operation | Python Operator | Description | Example |
| :-: | :-: | :- | :- |
| AND | `&` | 둘 다 1일경우 1 | 1101 & 0110 = 0100 |
| OR | `\|` | 하나라도 1일경우 1 | 1101 \| 0110 = 1111 |
| XOR | `^` | 두 값이 다를 때 1 | 1101 ^ 0110 = 1011 |
| NOT | `~` | 비트 값 반전 | ~ 1101 = 0010 |
| SHIFT | `>>`, `<<` | 지정한 비트 수 만큼 이동 | 1101 >> 2 = 11 \* |

\* _양수의 경우 `left shift`는 기존 값에 `* 2` , `right shift`는 `/ 2` 한 값과 같다._  
\* _음수의 shift 연산은 예상과 다르게 작동하므로 주의한다._

<br/>

## 비트마스크로 집합의 원소 다루기

1. **원소 추가** 는 해당 비트를 1로 만드는 것과 같다.  
   1로 마스킹 `S |= (1 << n)`

   ```python
    0b0000 |= (1<<2)
    0b0000 |= 0b0100 = 0b0100
   ```

2. **원소 삭제** 는 해당 비트를 0으로 만드는 것과 같다.  
   0으로 마스킹 `S |= ~(1 << n)`

   ```python
    0b1111 &= ~(1<<2)
    0b1111 &= 0b1011 = 0b1011
   ```

3. **원소 토글** 은 해당 비트가 1이면 0으로, 0이면 1로 만드는 것과 같다.  
   toggle : 특정 상태가 `on`이면 `off`로, `off`이면 `on`으로 전환하는 것.  
   XOR 연산 `S ^= (1 << n)`

   ```python
    0b0000 ^= (1<<2)
    0b0000 ^= 0b0100 = 0b0100
   ```

<br/>

## 비트 연산으로 집합 연산

집합끼리의 연산도 가능하다.  
비트에서 1의 개수는 집합의 크기를 의미한다.

```python
A | B   # 합집합
A & B   # 교집합
A & ~B  # 차집합
A ^ B   # 교집합의 여집합
```

<br/>

## 비트마스크 장점

- **수행 시간이 짧다.**  
  다른 자료구조를 사용했을 때의 추가 삭제 등 복잡한 과정을 비트 연산으로 처리하여 O(1)로 빠르게 수행할 수 있다.

- **코드가 간결해진다.**

- **메모리 효율적이다.**  
  하나의 정수 값으로 각 경우의 수를 표현할 수 있기 때문에 메모리 측면에서 효율적이다. 많은 경우의 수를 미리 계산하여 저장해두기에 DP 등에서도 유용하게 사용할 수 있다.

<br/>

---

## Reference

📄https://www.scaler.com/topics/data-structures/bit-masking/  
📄https://ko.wikipedia.org/wiki/마스크_(컴퓨팅)
